/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.TaskUsersWithSameID;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUserExistence
extends PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1059", false);
    private String m_user;
    private Hashtable<Object, Vector<Object>> usrIdTable = new Hashtable();

    public TaskUserExistence(String user) {
        this.m_user = user;
    }

    @Override
    public boolean performTask() {
        boolean oraDevEnv;
        ErrorDescription errDesc;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrRsltSet = new ResultSet();
        globalExec.checkUser(this.m_nodeList, this.m_user, usrRsltSet);
        this.m_resultSet.uploadResultSet(usrRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        String usrID = new String("");
        Hashtable ht = usrRsltSet.getResultTable();
        Enumeration<Object> e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String usrStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            result.setHasResultValues(true);
            result.setExpectedValue(Boolean.toString(true));
            if (result.getStatus() == 1) {
                usrStatus = ReportUtil.PASSED;
                usrID = (String)result.getResultInfoSet().elementAt(1);
                comment = ReportUtil.EXIST + "(" + usrID + ")";
                VerificationUtil.updateResultMap(this.usrIdTable, usrID, node);
                result.setActualValue(Boolean.toString(true));
            } else if (result.getStatus() == 3) {
                comment = ReportUtil.NOTEXIST;
                usrStatus = ReportUtil.FAILED;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7537", true, (Object[])new String[]{this.m_user, node}), s_msgBundle, "7537");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                result.setActualValue(Boolean.toString(false));
            } else {
                usrStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7538", true, (Object[])new String[]{node}), s_msgBundle, "7538");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, usrStatus, comment);
        }
        if (this.usrIdTable.size() > 1) {
            String errorMsg = s_msgBundle.getMessage("4123", true, (Object[])new String[]{this.m_user});
            ReportUtil.printError(errorMsg);
            errDesc = new ErrorDescription(errorMsg, s_msgBundle, "4123");
            this.m_resultSet.addErrorDescription(errDesc);
            e = this.usrIdTable.keys();
            StringBuffer usrIdsDisplayString = new StringBuffer();
            boolean first = true;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector<Object> nodeVector = this.usrIdTable.get(key);
                String nodes = VerificationUtil.strVect2List(nodeVector);
                if (first) {
                    first = false;
                    usrIdsDisplayString.append("[");
                } else {
                    usrIdsDisplayString.append("; ");
                }
                usrIdsDisplayString.append(key + ":" + nodes);
                String errorMessage = s_msgBundle.getMessage("4124", false, (Object[])new String[]{key, nodes});
                ReportUtil.sureprintln(errorMessage);
            }
            usrIdsDisplayString.append("]");
            ErrorDescription usrIdsED = new ErrorDescription(errorMsg + " " + usrIdsDisplayString.toString(), s_msgBundle, "4123");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, usrIdsED);
        } else if (this.usrIdTable.size() == 1 && !(oraDevEnv = VerificationUtil.isCVUTestEnv())) {
            TaskUsersWithSameID taskUsers = new TaskUsersWithSameID(this.m_nodeList, usrID);
            taskUsers.performTask();
            this.m_resultSet.uploadResultSet(taskUsers.getResultSet());
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0306", false, (Object[])new String[]{this.m_user}));
            return true;
        }
        if (this.isFixupReqd()) {
            this.generateFixups();
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0307", false, (Object[])new String[]{this.m_user, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4421", false) + ": " + this.m_user;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4472", false, (Object[])new String[]{this.m_user});
    }

    private void generateFixups() {
        FixupData fixData;
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        String uniqueIDOfInterest = null;
        if (this.usrIdTable.size() > 0) {
            Set<Object> idSet = this.usrIdTable.keySet();
            int maxNumOfnodesWithID = 0;
            for (Object id : idSet) {
                if (this.usrIdTable.get(id).size() <= maxNumOfnodesWithID) continue;
                maxNumOfnodesWithID = this.usrIdTable.get(id).size();
                uniqueIDOfInterest = (String)id;
            }
        }
        if (null != (fixData = this.createFixupData(uniqueIDOfInterest))) {
            this.setFixupData(fixData);
        }
    }

    private FixupData createFixupData(String userID) {
        FixupData fixUserData = new FixupData(null);
        ArrayList<String> createUserNodeList = new ArrayList<String>();
        ArrayList<String> updateUserNodeList = new ArrayList<String>();
        ArrayList userExistsNodeList = new ArrayList();
        if (VerificationUtil.isStringGood(userID) && this.usrIdTable.size() > 0 && this.usrIdTable.containsKey(userID)) {
            userExistsNodeList.addAll(this.usrIdTable.get(userID));
        }
        for (String node : this.m_nodeList) {
            if (userExistsNodeList.contains(node)) continue;
            if (this.usrIdTable.containsValue(node)) {
                updateUserNodeList.add(node);
                continue;
            }
            createUserNodeList.add(node);
        }
        if (!VerificationUtil.isStringGood(userID)) {
            GlobalExecution global = new GlobalExecution();
            ResultSet getIDResultSet = new ResultSet();
            List<String> uniqueIDList = global.getUniqueUID(createUserNodeList.toArray(new String[0]), 1, getIDResultSet);
            if (uniqueIDList.size() > 0) {
                userID = uniqueIDList.get(0);
            }
            if (!VerificationUtil.isStringGood(userID)) {
                List<String> failedNodesList = getIDResultSet.getFailedNodes();
                if (failedNodesList.size() == 0) {
                    failedNodesList.addAll(createUserNodeList);
                }
                for (String node : failedNodesList) {
                    fixUserData.addFixupGenerationFailedNode(node, new ErrorDescription(s_gMsgBundle.getMessage("9040", true, (Object[])new String[]{node})));
                }
                return fixUserData;
            }
        }
        fixUserData.addParticipatingNodes(createUserNodeList);
        fixUserData.addParticipatingNodes(updateUserNodeList);
        fixUserData.addFixupInstruction("USER", this.m_user);
        fixUserData.addFixupInstruction("UID", userID);
        String message = "Created fixup with \n User name (" + this.m_user + ")" + "\n User ID (" + userID + ")" + (createUserNodeList.size() > 0 ? "\n to create the user on nodes " + createUserNodeList : "") + (updateUserNodeList.size() > 0 ? "\n to update the user on nodes " + updateUserNodeList : "");
        Trace.out((String)message);
        VerificationLogData.logInfo(message);
        return fixUserData;
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrRsltSet = new ResultSet();
        globalExec.checkUser(this.m_nodeList, this.m_user, usrRsltSet);
        Hashtable ht = usrRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                String userID = (String)result.getResultInfoSet().elementAt(1);
                result.getResultInfoSet().add(0, this.m_user + "(" + userID + ")");
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NOTEXIST);
            result.setStatus(1);
        }
        return usrRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9977", false, (Object[])new String[]{this.m_user});
    }
}

